/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: AP_MidSys.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    Mid Sys - public

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-03-23  File created.

**************************************************************************************/


#ifndef __AP_MID_SYS_H
#define __AP_MID_SYS_H

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/queue.h>

/* router will check the link status or the remote application has to activate it */
#define MID_SYS_ROUTER_CHECKS_STATUS  0x00000001
/* Mid_Sys task shall not start the identification process on the link */
#define MID_SYS_ROUTER_NO_IDENTIFY    0x00000002
/* Mid_Sys task considers this router as mandatory for its Queue Identify function */
#define MID_SYS_ROUTER_MANDATORY      0x00000004

/* Midsys module type definitions */
#define MIDSYS_MODULE_TYPE_UNSPECIFIED  0x00000000
#define MIDSYS_MODULE_TYPE_MODULELOADER 0x00000001
#define MIDSYS_MODULE_TYPE_DPM          0x00000002


typedef BOOLEAN(*PFN_MID_HANDLE_PACKET)(RX_HANDLE hPool, RX_HANDLE hQueue, void* pvPacket, void* pvUser);
typedef void(*PFN_MID_INIT)(void* pvUser);
typedef void(*PFN_MID_DEINIT)(void* pvUser);

typedef struct MID_SYS_PACKET_MODULE_Ttag
{
  TAILQ_ENTRY(MID_SYS_PACKET_MODULE_Ttag) tListEntry;
  UINT32                                  ulModuleType;
  PFN_MID_INIT                            pfnInit;
  PFN_MID_DEINIT                          pfnDeinit;
  PFN_MID_HANDLE_PACKET                   pfnPacketHandler;
  void*                                   pvUser;
} MID_SYS_PACKET_MODULE_T;

/***************************************************************************************/
/* Mid Sys public, constants */


/***************************************************************************************/
/* Mid Sys public, prototypes */


RX_FATAL FAR    MidSysInit                  (void FAR*        pvPar, 
                                             UINT             uPar);

RX_FATAL FAR    MidSysModuleLoadInit        (void FAR*        pvPar,
                                             UINT             uPar);
  
RX_FATAL FAR    MidSysDpmInit               (void FAR*        pvPar,
                                             UINT             uPar);

RX_FATAL FAR    MidSysDdpInit               (void FAR*        pvPar,
                                             UINT             uPar);

RX_RESULT       MidSysRegisterModule        (MID_SYS_PACKET_MODULE_T*  ptModule);

void            MidSysUnregisterModule      (MID_SYS_PACKET_MODULE_T*  ptModule);

RX_RESULT       MidSysEnumModule            (UINT32                    ulIdx,
                                             MID_SYS_PACKET_MODULE_T** pptModule);

/* mandatory routers have to call this function in InitLocal otherwise the
   MID_SYS_ROUTER_MANDATORY flag will be ignored */
RX_RESULT FAR   Mid_SysRegisterRouter       (RX_HANDLE        hQueRouter,
                                             UINT32           ulMTU, 
                                             UINT32           ulFlags);
                                             
RX_RESULT FAR   Mid_SysModuleGetInitTable   (void FAR *       ptModuleUuid,
                                             void FAR*FAR*    ppvInitTable);
                                             
RX_RESULT FAR   Mid_SysModuleInstantiate    (void FAR*        ptModuleUuid,
                                             UINT             uInst,
                                             void FAR*        pvInitParam);
                                             
RX_RESULT FAR   Mid_SysTskIdentify          (UINT32           ulTskIdentifier,
                                             UINT             uInst,
                                             RX_HANDLE FAR*   phTsk);
                                             
RX_RESULT FAR   Mid_SysDpmCreateChannel     (RX_HIF_CHANNEL_T* ptChannel, 
                                             RX_HANDLE*        phChannel, 
                                             UINT32*           pulDPMChannel, 
                                             BOOLEAN           fCommit);

/***************************************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* #ifndef __MID_SYS_H */
